Attribute VB_Name = "mdCreateExtrusion"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function CreateExtrusion(inputSketch As aSketch, distance As Double, direction As Long, taperAngle As Double, side As Long, materialStatus As Long, extrusionName As String, thin As Boolean)

'Convenience Function to create an extrusion of the profile in the specified sketch

'Get the ProDESKTOP Application Object
GetApplicationObject

'Get the Active Part Document
Dim Part As PartDocument
Set Part = app.GetActiveDoc

'Continue only if Part is available
If Part Is Nothing Then
   Set CreateExtrusion = Nothing
   Exit Function
End If

'perform operation to create extrusion
Dim extrusion As aOperation
Set extrusion = app.GetClass("Extrusion").CreateExtrusion(Part.GetDesign, inputSketch, distance, direction, taperAngle, side, materialStatus, thin)

If Not extrusion Is Nothing Then
    extrusion.SetName extrusionName
    'Update the design
    Part.UpdateDesign
End If

Set CreateExtrusion = extrusion

End Function

